/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSColors {
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^#[a-fA-F0-9]{3}([a-fA-F0-9]{3})?$");
    private static final String HASH = "#";
    private static Map<String, String> NAMED_COLORS = new HashMap<String, String>();

    static {
        NAMED_COLORS = CollectionsUtil.newMap((Object[])new String[]{"aqua", "#00FFFF", "black", "#000000", "blue", "#0000FF", "fuchsia", "#FF00FF", "gray", "#808080", "green", "#008000", "lime", "#00FF00", "maroon", "#800000", "navy", "#000080", "olive", "#808000", "purple", "#800080", "red", "#FF0000", "silver", "#C0C0C0", "teal", "#008080", "white", "#FFFFFF", "yellow", "#FFFF00"});
    }

    public static boolean namedColorExists(String colorName) {
        return NAMED_COLORS.containsKey(colorName);
    }

    public static String getHexValueForName(String colorName) {
        return NAMED_COLORS.get(colorName);
    }

    public static Set<String> getNamedColors() {
        return Collections.unmodifiableSet(NAMED_COLORS.keySet());
    }

    public static String to6CharHexWithLeadingHash(String color) {
        if (CSSColors.namedColorExists(color.toLowerCase())) {
            return CSSColors.getHexValueForName(color.toLowerCase());
        }
        if (color.startsWith(HASH)) {
            color = color.substring(1);
        }
        if (color.length() == 3) {
            return (HASH + color.charAt(0) + color.charAt(0) + color.charAt(1) + color.charAt(1) + color.charAt(2) + color.charAt(2)).toUpperCase();
        }
        return HASH + color.toUpperCase();
    }

    public static boolean isColor(String value) {
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        if (CSSColors.namedColorExists(value)) {
            return true;
        }
        if (value.charAt(0) == '#' && (value.length() == 4 || value.length() == 7)) {
            return HEX_COLOR_PATTERN.matcher(value).matches();
        }
        return false;
    }
}

